#include <bits/stdc++.h>
#define ll long long
#define MAXN 500010
#define logn 20
using namespace std;
vector<ll> G[MAXN];
ll b[MAXN],x[MAXN],up[MAXN][logn],in[MAXN],out[MAXN],t=1,sz,vals[2*MAXN+(MAXN/2)],D[MAXN],revout[2*MAXN+(MAXN/2)];
void DFS(ll i,ll p)
{
    in[i]=t++;
    up[i][0]=p;
    for (ll j=1;j<logn;j++)
        up[i][j]=up[up[i][j-1]][j-1];
    for (ll next : G[i])
    {
        D[next]=D[i]+1;
        DFS(next,i);
    }
    out[i]=t++;
}
bool Is_Ancestor(ll u,ll v)
{
    return in[u]<=in[v] && out[u]>=out[v];
}
ll Get_Ancestor(ll u,ll dist)
{
    ll cur=logn-1;
    while (dist)
    {
        if ((1<<cur)<=dist)
        {
            dist-=(1<<cur);
            u=up[u][cur];
        }
        cur--;
    }
    return u;
}
struct seg_tree
{
    vector<ll> st;
    void Init()
    {
        sz=1;
        while (sz<t)
            sz <<= 1;
        st.resize(2*sz+2);
    }
    void Build()
    {
        for (ll i=sz;i<sz+t;i++)
            st[i]=vals[i-sz+1];
        for (ll i=sz-1;i>0;i--)
            st[i]=max(st[2*i],st[2*i+1]);
    }
    void Update(ll pos,ll val,ll x,ll lx,ll rx)
    {
        if (lx==rx)
        {
            st[x]=val;
            return;
        }
        ll mid=(lx+rx)/2;
        if (pos<=mid)
            Update(pos,val,2*x,lx,mid);
        else
            Update(pos,val,2*x+1,mid+1,rx);
        st[x]=max(st[2*x],st[2*x+1]);
    }
    ll Calc(ll l,ll r,ll x,ll lx,ll rx)
    {
        if (lx>r || rx<l)
            return 0;
        if (lx>=l && rx<=r)
            return st[x];
        ll mid=(lx+rx)/2;
        return max(Calc(l,r,2*x,lx,mid),Calc(l,r,2*x+1,mid+1,rx));
    }
};
seg_tree S;
int main()
{
    ios::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    ll n,u,v;
    cin >> n;
    for (ll i=1;i<n;i++)
    {
        cin >> u >> v;
        G[u].push_back(v);
    }
    DFS(1,1);
    for (ll i=1;i<=n;i++)
    {
        revout[out[i]]=i;
        cin >> b[i];
        if (b[i])
            vals[in[i]]=out[i];
    }
    for (ll i=1;i<=n;i++)
        cin >> x[i];
    S.Init();
    S.Build();
    for (ll i=1;i<=n;i++)
    {
        if (x[i])
        {
            if (!b[x[i]])
                S.Update(in[x[i]],out[x[i]],1,1,sz);
            else
                S.Update(in[x[i]],0,1,1,sz);
            b[x[i]]^=1;
        }
        ll cnt=0,cur=i;
        while (true)
        {
            if (D[cur]<i)
            {
                cout << cnt+1 << " ";
                break;
            }
            ll maxx=S.Calc(in[Get_Ancestor(cur,i)],in[cur]-1,1,1,sz);
            if (!maxx || !Is_Ancestor(revout[maxx],cur))
            {
                cout << "-1 ";
                break;
            }
            cnt++;
            cur=revout[maxx];
        }
    }
    return 0;
}